unit Present35;

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, ExtCtrls, ComCtrls, ExtDlgs,
  ShlObj, ShellApi,
  //  
  PictureTools;

// =========================================================================
//     TPresentation
// =========================================================================
// -------------------------------------------------------------------------
const
   PresentExtName = 'pf';     //    

//        2 
const
   NodeMainImg = 'MainImg';   //   Image 
   NodeImage   = 'Image';     //   Image 
   NodeVideo   = 'Video';     //   Video 
   NodeDocum   = 'Docum';     //   Docum 

const
   Lv0SelImg   = 0;           //     Level = 0
   Lv0UnSelImg = 0;           //    Level = 0
   Lv1SelImg   = 1;           //     Level = 1
   Lv1UnSelImg = 1;           //    Level = 1
   Lv2SelImg   = 2;           //     Level = 2
   Lv2UnSelImg = 3;           //     Level = 2

// =========================================================================
//  TPresentation
// =========================================================================
type TPresentation = class(TPictureTools)
private
   // ------------------
   //  
   fImage               : TImage;
   fTreeView            : TTreeView;
   fStatusBar           : TStatusBar;
   // ------------------
   fFullPesentDir       : string;       //   
   fSubDirPresentName   : string;       //   
   fFullPresentFileName : string;       //    
   // -------------------
   fSlideList           : TStringList;  //       
   // ------------------
   fShowInd             : integer;      //     List
   fReShowInd           : boolean;      //     fShowInd
   // ------------------
   //=========================
   //      
   procedure RunShellExecute(RqHandle : HWND; RqFileName : string);
   //      TreeView
   procedure DoTreeViewChange(RqNode : TTreeNode);
   // ------------------
   //     
   procedure SetShowInd(Index : integer);
   //      1
   procedure ExpandNodeL1(RqIndex : integer);
   //    onMouseDown
   procedure DoMouseDown(Button: TMouseButton; Shift: TShiftState;
                         X, Y: Integer);
   //    fImage
   procedure MouseDown(Sender: TObject; Button: TMouseButton;
                       Shift: TShiftState; X, Y: Integer);
   //    fTreeView
   procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
   // ------------------
   //     
   procedure ShowImagegReport(RqFileName : string);
   //    
   procedure ShowSlideReport(RqSlideInd : integer;
                             RqFileName : string);
   //   
   function LoadOneSlide(RqSlideInd : integer): boolean;
   // ------------------
   //    RqTopNode  TreeView 
   //     SlideList
   procedure SlideListFromSubTreeNodes
              (RqTreeView  : TTreeView;     // TreeView
               RqTopNode   : TTreeNode;     // Node  
               RqSlideList : TStringList);  //  
   //     
   procedure UpdateNodesIcons();
   // ------------------
   // ------------------
protected
   //     
   function BuildSlideList() : boolean;
   // ------------------
public
   // ------------------
   // 
   constructor Create(RqImage     : TImage;
                      RqTreeView  : TTreeView;
                      RqStatusBar : TStatusBar);
   // 
   procedure Free();
   // ------------------
   //    
   procedure ReShowCurrentImage();
   //      
   procedure OpenOnePicture();
   //      Jpeg
   procedure ShowOneJpeg(RqFileName : string);
   // ------------------
   //    
   procedure PresentOnOf(RqON : boolean);
   // ------------------
   //  
   function LoadPresentation
           (RqApplicationDir : string) : boolean; overload;
   //  
   function LoadPresentation(
            RqApplicationDir   : string;
            RqPresentationName : string ) : boolean; overload;
   // ------------------
   property FullPesentDir : string read fFullPesentDir;
   property FullPresentFileName : string read fFullPresentFileName;
   property ShowInd : integer read fShowInd write SetShowInd;
   // ------------------
end;

implementation

// =========================================================================
// =========================================================================
//   TPresentation
// =========================================================================
// =========================================================================
// -------------------------------------------------------------------------
// 26.10.2016
constructor TPresentation.Create(RqImage     : TImage;
                                 RqTreeView  : TTreeView;
                                 RqStatusBar : TStatusBar);
var Ind : integer;
begin
    if Assigned(RqImage)    and
       Assigned(RqTreeView) and
       Assigned(RqStatusBar)
    then begin
       inherited Create(RqImage);
       // ------------------------------
       fImage := RqImage;
       fImage.Anchors := [akLeft,akTop];
       fImage.Align := alNone;
       fImage.OnMouseDown := MouseDown;
       // ------------------------------
       fTreeView := RqTreeView;
       fTreeView.Align := alClient;
       fTreeView.OnChange := TreeViewChange;
       AutoSize  := True;
       Proportional := True;
       // ------------------------------
       fStatusBar := RqStatusBar;
       // ------------------------------
       fSlideList := TStringList.Create;
       fShowInd   := 0;
       fReShowInd := False;
       //  fStatusBar
       if fStatusBar.Panels.Count = 0
       then begin
          with fStatusBar do
          begin
             Panels.BeginUpdate;
             Ind := Panels.Count - 1;
             try
                 Panels.Add;  Inc(Ind);
                 Panels.Items[Ind].Text := '';
                 Panels.Items[Ind].Width := 150;
                 Panels.Add;  Inc(Ind);
                 Panels.Items[Ind].Text := '';
                 Panels.Items[Ind].Width := 150;
                 Panels.Add;  Inc(Ind);
                 Panels.Items[Ind].Text := '';
                 Panels.Items[Ind].Width := 2000;
             finally
                Panels.EndUpdate;
             end;
          end; // of with RqStatusBar
       end;
    end;
end;
// -------------------------------------------------------------------------
// 26.10.2016
procedure TPresentation.Free();
begin
   fImage.OnMouseDown := nil;
   fTreeView.OnChange := nil;
   fSlideList.Free;
   inherited Free;
end;

// =========================================================================
//       fTreeView
// =========================================================================
// -------------------------------------------------------------------------
// 14.10.2016
//      
// uses ShlObj, ShellApi;
procedure TPresentation.RunShellExecute(RqHandle : HWND; RqFileName : string);
var FileName   : string;
    RetutnCode : HINST;
begin
 FileName := Trim(RqFileName);
 if not FileExists(FileName) then Exit;
 //     
 RetutnCode := ShellExecute(RqHandle, nil, PChar(FileName),
                            nil, nil, Sw_ShowNormal);
 case RetutnCode of
 0	                    : ShowMessage('The operating system is out of memory or resources.');
 ERROR_FILE_NOT_FOUND	  : ShowMessage('The specified file was not found.');
 ERROR_PATH_NOT_FOUND	  : ShowMessage('The specified path was not found.');
 ERROR_BAD_FORMAT	      : ShowMessage('The .exe file is invalid (non-Win32 .exe or error in .exe image).');
 SE_ERR_ACCESSDENIED	  : ShowMessage('The operating system denied access to the specified file.');
 SE_ERR_ASSOCINCOMPLETE	: ShowMessage('The file name association is incomplete or invalid.');
 SE_ERR_DDEBUSY	        : ShowMessage('The DDE transaction could not be completed because other DDE transactions were being processed.');
 SE_ERR_DDEFAIL	        : ShowMessage('The DDE transaction failed.');
 SE_ERR_DDETIMEOUT	    : ShowMessage('The DDE transaction could not be completed because the request timed out.');
 SE_ERR_DLLNOTFOUND	    : ShowMessage('The specified DLL was not found.');
 SE_ERR_NOASSOC	        : ShowMessage('There is no application associated with the given file name extension.');
 SE_ERR_OOM	            : ShowMessage('There was not enough memory to complete the operation.');
 SE_ERR_SHARE	          : ShowMessage('A sharing violation occurred.');
 end;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//      TreeView
procedure TPresentation.DoTreeViewChange(RqNode : TTreeNode);
const LevelOK = 3;        //    
var wExtName   : string;
    wFileName  : string;
    wControl   : TControl;
begin
   if not Assigned(RqNode) then Exit;
   if RqNode.Level <> LevelOK then Exit;
   wFileName := fFullPesentDir
             + '\' + RqNode.Parent.Text
             + '\' + RqNode.Text;
   //     
   fStatusBar.Panels[2].Text := wFileName;
   if FileExists(wFileName)
   then begin
      fStatusBar.Panels[0].Text := '';
      fStatusBar.Panels[1].Text := 'OK :';
   end
   else begin
      fStatusBar.Panels[0].Text := '';
      fStatusBar.Panels[1].Text := '   :';
      Exit;
   end;
   //  
   wExtName := UpperCase(ExtractFileExt(RqNode.Text));
   if (wExtName = '.JPG') or (wExtName = '.JPEG')
   then begin
       //  .JPEG 
       JpegToImage(wFileName);
       ShowImagegReport(wFileName);
       //      
       fReShowInd := True;
    end
    else begin
       wControl := fTreeView;
       while Assigned(wControl)
       do begin
          if wControl is TForm
          then begin
              //      
              RunShellExecute((wControl as TForm).Handle, wFileName);
              Exit;
          end;
          wControl := wControl.Parent;
       end;
    end;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//    onTreeViewChange
procedure TPresentation.TreeViewChange(Sender: TObject; Node: TTreeNode);
begin
   //      TreeView
   DoTreeViewChange(Node);
end;


// =========================================================================
//       fImage
// =========================================================================
// -------------------------------------------------------------------------
// 26.10.2016
//      1
procedure TPresentation.ExpandNodeL1(RqIndex : integer);
var Node : TTreeNode;
begin
  if RqIndex < 0 then Exit;
  Node := fTreeView.TopItem;
  //     1 (  )
  Node.Expand(False);
  //       1
  if (Node.Count > 0) and (RqIndex < Node.Count)
  then begin
      Node.Item[RqIndex].Expand(True);
  end;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//     
procedure TPresentation.SetShowInd(Index : integer);
begin
  if fSlideList.Count <= 0  then Exit;
  if (Index >= 0) and (Index < fSlideList.Count)
  then begin
       if Assigned(fSlideList.Objects[Index])
       then begin //    
           if LoadOneSlide(Index)
           then begin
              fShowInd := Index;
              //    
              ExpandNodeL1(fShowInd);
            end;
       end
       else MessageDlg('!     ' + IntToStr(Index + 1)
            + #13#10 + '     .',
              mtWarning, [mbOk], 0);
  end;
end;
// -------------------------------------------------------------------------
// 26.10.2016
//    onMouseDown
procedure TPresentation.DoMouseDown(Button: TMouseButton; Shift: TShiftState;
                                    X, Y: Integer);
var RowH, ColW : extended;
    Row,  Col  : integer;
    Ind        : integer;
begin
  if fSlideList.Count <= 0 then Exit;
  //   ()   
  if fReShowInd
  then begin
     if (fShowInd >= 0)
     then LoadOneSlide(fShowInd);
     fReShowInd := False;
     Exit;
  end;
  // --------------------
  //    
  fTreeView.FullCollapse;
  fTreeView.Repaint;
  // --------------------
  //  
  if fShowInd > 0
  then begin
      //     Ind
      SetShowInd(0);
  end
  else begin
      RowH := ShowWidth  / 4;
      ColW := ShowHeight / 4;
      Col  := Trunc(X / RowH);
      Row  := Trunc(Y / ColW);
      Ind := -1;
      case Row of
      0 : begin
             case Col of
             0 : Ind := 1;
             1 : Ind := 2;
             2 : Ind := 3;
             3 : Ind := 4;
             end;
          end;
      1 : begin
             case Col of
             0 : Ind := 5;
             1 : Ind := 0;
             2 : Ind := 0;
             3 : Ind := 6;
             end;
          end;
      2 : begin
             case Col of
             0 : Ind := 7;
             1 : Ind := 0;
             2 : Ind := 0;
             3 : Ind := 8;
             end;
          end;
      3 : begin
             case Col of
             0 : Ind := 9;
             1 : Ind := 10;
             2 : Ind := 11;
             3 : Ind := 12;
             end;
          end;
      end;
      //     Ind
      SetShowInd(Ind);
  end;
end;
// -------------------------------------------------------------------------
// 26.10.2016
//    on MouseDown
procedure TPresentation.MouseDown(Sender: TObject; Button: TMouseButton;
                                  Shift: TShiftState; X, Y: Integer);
begin
    DoMouseDown(Button, Shift,  X, Y);
end;
// =========================================================================
//       fImage
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
//    
procedure TPresentation.ReShowCurrentImage();
begin
     if ShowOK then ShowOneJpeg(ShowFileName);
end;
// -------------------------------------------------------------------------
// 27.10.2016
//     
procedure TPresentation.ShowImagegReport(RqFileName : string);
var Scale : integer;
begin
  with fStatusBar
  do begin
     if ShowOK
     then begin
       //   Panels[0]
       if AutoSize
       then begin
          if Proportional
          then begin
             // 
             if BitMapWidth > 0
             then Scale := Round(100 * ShowWidth / BitMapWidth)
             else Scale := 0;
             Panels[0].Text := ' Image Scale : '
                               + IntToStr(Scale)  + '% ';
          end
          else begin
             //   
             Panels[0].Text := ' Image Size : '
                               + IntToStr(ShowWidth)
                               + ' x '
                               + IntToStr(ShowHeight);
          end;
       end
       else begin
          //    (not AutoSize)
          Panels[0].Text := ' Image Size : '
                            + IntToStr(BitMapWidth)
                            + ' x '
                            + IntToStr(BitMapHeight);
       end;
       Panels[1].Text := ' Image Size : '
                         + IntToStr(BitMapWidth)
                         + ' x '
                         + IntToStr(BitMapHeight);
       //    Panels[2]
       Panels[2].Text := RqFileName;
     end
     else begin
       //    Panels[2]
       Panels[0].Text := '';
       Panels[1].Text := '    ';
       Panels[2].Text := ' ' + RqFileName;
     end; // if ShowOK
  end;
end;
// -------------------------------------------------------------------------
// 26.10.2016
//    
procedure TPresentation.ShowSlideReport(RqSlideInd : integer;
                                        RqFileName : string);
begin
  ShowImagegReport(RqFileName);
  with fStatusBar
  do begin
     if ShowOK and (RqSlideInd >= 0) and (fSlideList.Count > 0)
     then //    
          Panels[1].Text := ' Slide : '
                           + IntToStr(RqSlideInd + 1)
                           + ' of : '
                           + IntToStr(fSlideList.Count)
       else Panels[1].Text := '';
  end;
end;
// -------------------------------------------------------------------------
// 26.10.2016
//   
function TPresentation.LoadOneSlide(RqSlideInd : integer): boolean;
var wFileName : string;
begin
  Result := False;
  if fSlideList.Count > 0
  then begin
    wFileName := fFullPesentDir
              + '\' + NodeMainImg
              + '\' + Trim(fSlideList.Strings[RqSlideInd]);
    if FileExists(wFileName)
    then begin
        //    Jpeg
        fImage.Width  := fImage.Parent.Width  - 4;
        fImage.Height := fImage.Parent.Height - 4;
        Result := JpegToImage(wFileName);
        //    
        ShowSlideReport(RqSlideInd, LoadFileName);
    end
    else begin
       //   
       with fStatusBar do
       begin
          Panels[0].Text := '';
          Panels[1].Text := ' ERROR';
          Panels[2].Text := '    : ' + wFileName;
       end;
    end;
  end;
end;
// =========================================================================
//      JPG - 
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
//      Jpeg
procedure TPresentation.ShowOneJpeg(RqFileName : string);
begin
  if FileExists(RqFileName)
  then begin
     fImage.Width  := fImage.Parent.Width  - 4;
     fImage.Height := fImage.Parent.Height - 4;
     //    Jpeg
     JpegToImage(RqFileName);
     ShowImagegReport(RqFileName);
  end
  else begin
     fStatusBar.Panels[0].Text := '';
     fStatusBar.Panels[1].Text := '    ';
     fStatusBar.Panels[2].Text := RqFileName;
  end;
end;
// -------------------------------------------------------------------------
// 26.10.2016
//      
procedure TPresentation.OpenOnePicture();
var wDialog   : TOpenPictureDialog;
begin
    wDialog := TOpenPictureDialog.Create(nil);
    wDialog.InitialDir := fFullPesentDir;
    wDialog.Filter :=  'Image files (*.jpg)|*.JPG';
    if wDialog.Execute
    then begin
        fReShowInd := True;
        ShowOneJpeg(wDialog.FileName);
    end;
    wDialog.Free;
end;

// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
// 04.11.2016
//    
procedure TPresentation.PresentOnOf(RqON : boolean);
begin
   fImage.Enabled := RqON;
end;

// -------------------------------------------------------------------------
// 26.10.2016
//    RqTopNode  TreeView 
//     SlideList
procedure TPresentation.SlideListFromSubTreeNodes
              (RqTreeView  : TTreeView;     // TreeView
               RqTopNode   : TTreeNode;     // Node  
               RqSlideList : TStringList);  //  
var wNode : TTreeNode;
    Ind   : integer;
begin
  with RqTreeView do
  begin
    if RqTopNode.Count < 1 then Exit;
    for Ind := 0 to (RqTopNode.Count - 1)
    do begin
       wNode := RqTopNode.Item[Ind];
       if (wNode.Level = 2) and
          (wNode.Text = NodeMainImg) and
          (wNode.Count = 0)
       then begin
          RqSlideList.AddObject(' ', nil);
       end;
       if (wNode.Level = 3) and
          (wNode.Parent.Text = NodeMainImg) and
          (Ind = 0)  //  
       then begin
          RqSlideList.AddObject(wNode.Text, wNode);
       end;
       if wNode.Count > 0
       //  
       then  SlideListFromSubTreeNodes(RqTreeView, wNode, RqSlideList);
    end;
  end;
end;
// -------------------------------------------------------------------------
// 26.10.2016
//     
function TPresentation.BuildSlideList() : boolean;
var TopNode : TTreeNode;
begin
   Result := False;
   try
     //  RqSlideList
     if not Assigned(fSlideList)
     then fSlideList := TStringList.Create;
     fSlideList.Clear;
     //  RqSlideImgList
     TopNode := fTreeView.TopItem;
     SlideListFromSubTreeNodes (fTreeView,    // Tree
                                TopNode,      // Node  
                                fSlideList);  //  
     Result := True;
   except
      MessageDlg('    ',
                  mtError, [mbOk], 0);
   end;
end;
// -------------------------------------------------------------------------
// 26.10.2016
//     
procedure TPresentation.UpdateNodesIcons();
var wNode : TTreeNode;
    Level : integer;
begin
  with fTreeView do
  begin
    wNode := Items.GetFirstNode;   //  Root 
    while wNode <> nil do
    begin
       Level := wNode.Level;
       case Level of
       0: begin // Root
             wNode.ImageIndex    := Lv0SelImg;
             wNode.SelectedIndex := Lv0UnSelImg;
          end;
       1: begin // 
             wNode.ImageIndex    := Lv1SelImg;
             wNode.SelectedIndex := Lv1UnSelImg;
          end;
       2: begin //   
             wNode.ImageIndex    := Lv2UnSelImg;
             wNode.SelectedIndex := Lv2SelImg;
          end;
          else begin
             wNode.ImageIndex    := -1;
             wNode.SelectedIndex := -1;
          end;
       end;
       wNode := wNode.GetNext;     //   
    end;
  end;  // of with RqTree
end;
// -------------------------------------------------------------------------
// 26.10.2016
//  
// OVERLOAD
function TPresentation.LoadPresentation(RqApplicationDir : string) : boolean;
var wDialog   : TOpenDialog;
    wFileName : string;      //    
begin
    Result  := False;
    if (RqApplicationDir = '') then Exit;
    // -------------------------------
    wDialog := TOpenDialog.Create(nil);
    wDialog.InitialDir := RqApplicationDir;
    wDialog.Filter :=  'Presentation File (*.' + PresentExtName
                     + ') |*.' + PresentExtName;
    if wDialog.Execute
    then begin
       wFileName := wDialog.FileName;
       //   
       try
         fTreeView.Items.Clear;
         fTreeView.LoadFromFile(wFileName);
         Result := True;
       except
         MessageDlg('     :'
                  +  #13#10 + wFileName, mtError, [mbOk], 0);
       end;
       //  
       if Result
       then begin
          UpdateNodesIcons();
          //    
          fFullPresentFileName := wFileName;
          fFullPesentDir  := ExtractFilePath(wFileName);
          fSubDirPresentName   := ExtractFileName(wFileName);
          //     
          Result := BuildSlideList();
       end;
       //  
       if Result
       then begin
          //    
          //   
          fShowInd := 0;
          Result := LoadOneSlide(fShowInd);
          //     1
          fTreeView.TopItem.Expand(False);
       end;
    end;
    wDialog.Free;
end;

// -------------------------------------------------------------------------
// 26.10.2016
//  
// OVERLOAD
function TPresentation.LoadPresentation(RqApplicationDir   : string;
                                        RqPresentationName : string ) : boolean;
var
    wName : string;      //   ,   
begin
    Result  := False;
    if (RqApplicationDir = '') or (RqPresentationName = '') then Exit;
    wName := RqApplicationDir + '\' + RqPresentationName;
    if not DirectoryExists(wName) then Exit;
    // -------------------------------
    //  
    //  
    try
       //    
       wName := wName + '\' + RqPresentationName + '.' + PresentExtName;
       fTreeView.Items.Clear;
       fTreeView.LoadFromFile(wName);
       Result := True;
     except
         MessageDlg('     :'
                  +  #13#10 + wName, mtError, [mbOk], 0);
     end;
     //  
     if Result
     then begin
          UpdateNodesIcons();
          //    
          fFullPresentFileName := wName;
          fFullPesentDir       := ExtractFilePath(wName);
          fSubDirPresentName   := ExtractFileName(wName);
          //     
          Result := BuildSlideList();
      end;
      //  
      if Result
      then begin
          //    
          //   
          fShowInd := 0;
          Result := LoadOneSlide(fShowInd);
          //     1
          fTreeView.TopItem.Expand(False);
       end;
end;

// =========================================================================
// 
// =========================================================================


end.
